	function DM = CA_DESIGN_MARGIN_Z(N, wcT, wsT, Amax, Amin, Case)
	
	%	Computes the design margin for a digital Nth-order Cauer filter.
	%	The program maximize/minimize one of the design parameters, i.e.,
	%	Case = 1, 2, 3, or 4 for the parameters wcT, wsT, Amax, Amin, respectively.
	
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	LW 2018-04-04
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com	
	
	if N ~= round(N)
		disp([ 'N must be an integer'])
		break
	end	
	switch Case
	case 1
		JJ = sqrt(sqrt((10^(Amin/10)-1))/sqrt((10^(Amax/10)-1)));
		for k = 1:4
			JJ = JJ*JJ;
			if JJ <= 10^150 
				JJ = JJ+sqrt(JJ*JJ-1);
			else
				JJ = 2*JJ;
			end
		end
		A = (JJ/(2^(N-1)))^(1/N);
		for k = 1:4
			A = sqrt((A+1/A)/2);
		end
		wcT = 2*atan(tan(wsT/2)/(A^2))/pi;
		DM = wcT;
	case 2
		JJ = sqrt(sqrt((10^(Amin/10)-1))/sqrt((10^(Amax/10)-1)));
		for k = 1:4
			JJ = JJ*JJ;
			if JJ <= 10^150 
				JJ = JJ+sqrt(JJ*JJ-1);
			else
				JJ = 2*JJ;
			end
		end
		A = (JJ/(2^(N-1)))^(1/N);
		for k = 1:4
			A = sqrt((A+1/A)/2);
		end
		wsT = 2*atan(A^2*tan(wcT/2))/pi;
		DM = wsT;		
	case 3
		A = sqrt(tan(wsT/2)/tan(wcT/2));
		for k = 1:4
			A = A*A;
			A = A+sqrt(A*A-1);
		end
		JJ = 2^(N-1)*A^N;
		for k = 1:4
			JJ = sqrt((JJ+1/JJ)/2);
		end
		Amax = 10*log10(1+(10^(Amin/10)-1)/JJ^4);
		DM = Amax;
	case 4
		A = sqrt(tan(wsT/2)/tan(wcT/2));
		for k = 1:4
			A = A*A;
			A = A+sqrt(A*A-1);
		end
		JJ = 2^(N-1)*A^N;
		for k = 1:4
			JJ = sqrt((JJ+1/JJ)/2);
		end
		Amin = 10*log10(1+(10^(Amax/10)-1)*JJ^4);	
		DM = Amin;
	end

